export default {
  content: ["./**/*.{html,js}"],
  theme: {
    colors: {
      white: "#ffffff",
      black: "#000000",
      blue: "#1fb6ff",
      red: "#FF3430",
      purple: "#7e5bef",
      pink: "#ff49db",
      orange: "#ff7849",
      green: "#13ce66",
      yellow: "#ffc82c",
      "gray-dark": "#273444",
      gray: "#8492a6",
      "gray-light": "#d3dce6",
      transparent: "transparent",
    },
    fontFamily: {
      sans: ["Graphik", "sans-serif"],
      serif: ["Merriweather", "serif"],
    },
    screens: {
      sm: "357px",
      md: "768px",
      lg: "1024px",
      xl: "1200px",
      "2xl": "1920px",
    },
    extend: {
      boxShadow: {
        header: "0px 2px 8px 0px rgba(0, 0, 0, 0.2)",
      },
      transition: {
        20: "0.2s",
      },
      lineHeight: {
        1: "1",
      },
      textColor: {
        white: "#ffffff",
      },
      fontSize: {
        12: "12px",
        14: "14px",
        16: "26px",
        18: "18px",
        20: "20px",
        24: "24px",
        26: "26px",
        28: "28px",
        30: "30px",
        32: "32px",
        34: "34px",
        36: "36px",
        38: "38px",
        40: "40px",
      },
      margin: {
        5: "5px",
        10: "10px",
        16: "16px",
        20: "20px",
        24: "24px",
        30: "30px",
        40: "40px",
        50: "50px",
        60: "60px",
        80: "80px",
        100: "100px",
      },
      padding: {
        5: "5px",
        10: "10px",
        20: "20px",
        24: "24px",
        30: "30px",
        40: "40px",
        50: "50px",
        60: "60px",
        80: "80px",
        100: "100px",
      },
      gap: {
        5: "5px",
        10: "10px",
        20: "20px",
        24: "24px",
        30: "30px",
        40: "40px",
        50: "50px",
        60: "60px",
        80: "80px",
        100: "100px",
      },
      borderRadius: {
        0: "0",
        4: "4px",
        6: "6px",
        8: "8px",
        10: "10px",
        12: "12px",
        18: "18px",
        10: "10px",
        20: "20px",
        24: "24px",
      },
    },
  },
};
